<?php

//no caching since picture-sizes might change by editing gallery_config.php 
clearstatcache();
header("Cache-Control: no-cache, must-revalidate");
header("Pragma: no-cache");



function gallery_pagesetup() 
{			
		//Vars
		global $PAGE;
    	global $CFG;
    	global $ident;
		global $folder;

		$page_owner = $profile_id;
		
		//Include
		require_once (dirname(__FILE__)."/default_templates.php");
		
			
	//logged in?
	if (isloggedin()) 
	{
		if (defined("context") && context == "gallery" && $page_owner == $_SESSION['userid'])
		{
           
			$PAGE->menu[] = array( 'name' => 'gallery',
                  				   'html' => "<li><a href=\"{$CFG->wwwroot}mod/gallery/\" >" .__gettext("Gallery").'</a></li>');
	// otherwise add as TAB
    	} else 
		{
		   	$PAGE->menu[] = array( 'name' => 'gallery',
                  				  'html' => "<li><a href=\"{$CFG->wwwroot}mod/gallery/\" >" .__gettext("Gallery").'</a></li>');
  		}
	} 
}
 function gallery_init() 
 {
    global $CFG;
    global $function;
	
		//File-Upload Radiobutton Menuitem
		$CFG->folders->handler["gallery"]['menuitem'] = __gettext("Gallery");
        $CFG->folders->handler["gallery"]['view'] = "gallery_folder_view";
        
		//Display in Sidebar
		$function['display:sidebar'][] = $CFG->dirroot . "mod/gallery/user_info_menu.php";
		
		//changed the mod/file/files_view.php so that the uploadmenu does no more exist for the Gallery
		$function['gallery:view'][] = $CFG->dirroot . "mod/gallery/lib/gallery_view.php";    
       	    
 }

function gallery_folder_view($folder)
{	    
        global $CFG;
         // Find out who's the owner
            
        global $page_owner;
        $owner_username = user_info('username', $page_owner);
        
        // If we're not in the parent folder, provide a link to return to the parent
        if ($folder->ident != -1)
		{
            $folder->name = stripslashes($folder->name);
        }
        
                
        $body = "<h2>" . $folder->name . "</h2>";
        
        //did we already get an ident by a former run?
		if(isset($_GET[ident])&&(is_numeric($_GET[ident])))
		{
			$folder->ident=$_GET[ident];
		}
		else if(isset($_GET[ident])&&(!(is_numeric($_GET[ident]))))
		{
			die("ident has a bad type");
		}
				
		if ($folder->idents = get_records_select('file_folders',"parent = $folder->ident AND (". run("users:access_level_sql_where") . ") and files_owner = $page_owner")) {
            $subFolders = __gettext("Subfolders"); 
            $body .= <<< END
                
                            <h3>
                                $subFolders
                            </h3>
        
END;
            
            foreach($folder->idents as $folder->ident_details) 
			{
                
                if (run("users:access_level_check",$folder->ident_details->access) == true) 
					{
                    $username = $owner_username;
                    $ident = (int) $folder->ident_details->ident;
                    $name = get_access_description($folder->ident_details->access);
                    $name .= stripslashes($folder->ident_details->name);
                    $folder->identmenu = file_folder_edit_links($folder->ident_details);
                    $keywords = display_output_field(array("","keywords","folder","folder",$ident,$folder->ident_details->owner));
                    
					$parent = (int) $folder->ident;
					
					if(($folder->ident)!=-1)
					{
						if (defined("context") && context == "gallery")	
						{
							$url = $CFG->wwwroot . "mod/gallery/index.php?ident=$ident";										
						}
						else
						{
							$url = $CFG->wwwroot . "news/files/$ident";
						}
					
					}
					else
					{
						$url=$CFG->wwwroot . "mod/gallery/index.php?ident=$ident";
					}
					
					
					if ($keywords) 
					{
                        $keywords = __gettext("Keywords: ") . $keywords;
                    }
                    $body .= templates_draw(array(
                                                  'context' => 'folder',
                                                  'username' => $username,
      											  'url' => $url,
												  'ident' => $ident,
                                                  'name' => $name,
                                                  'menu' => $folder->identmenu,
                                                  'icon' => $CFG->wwwroot . "mod/file/folder.png",
                                                  'keywords' => $keywords
                                                  )
                                            );
                }//End outer If
                
            }//End foreach
        }
        
		
// Bildparameter
require_once(dirname(dirname(__FILE__))."/gallery/gallery_config.php");

//How many pictures do we have
$number_of_rows = get_records_select('files',"folder = ? AND files_owner = ?",array($folder->ident,$page_owner)); 
$number_of_rows = count($number_of_rows);

//starting pint for picture counting		
$i=0;

//if the supplied $idx does not fit set it to "1"
if(isset($_GET[idx])&&(!(is_numeric($_GET[idx]))))
{
	die("idx has a bad type");
}

if($_GET[idx]<=0||((($_GET[idx]-1)*$files_per_page)>$number_of_rows))
{
	$_GET[idx]=1;
}

//if $idx is set, use it otherwise set the current index to "1"
if(isset($_GET[idx]))
{
	$picindex=$_GET[idx];
}
else
{
	$picindex=1;
}

$picindexM=$picindex-1;
$auswahl=$picindex*$files_per_page;
$picMin=$picindexM*$files_per_page;
$linebreak="</p><p align='center'>";		

if($picindex<2)
{
	$files = get_records_select('files',"folder = ? AND files_owner = ?",array($folder->ident,$page_owner),"","*","$picindexM","$files_per_page"); 
}		
if($picindex>=2)
{
	$files  = get_records_select('files',"folder = ? AND files_owner = ?",array($folder->ident,$page_owner),"","*","$picMin","$files_per_page"); 
}		
		if($files)
		{
           //thumbnail allignment
		   $body .="<p align='center'>";
			
			foreach($files as $file) 
			{
                ++$i;
			
			if($i<=$files_per_page)
			{
				
				if (run("users:access_level_check",$file->access) == true || $file->owner == $_SESSION['userid']) {
                    $username = $owner_username;
                    $ident = (int) $file->ident;
                    $folder->ident = $file->folder;
                   
					$originalname = stripslashes($file->originalname);
                    $location= $file->location;
					
					//path of the picture in web
					$filepath = $CFG->wwwroot . "$username/files/$folder->ident/$ident/" . urlencode($originalname);
					
					//path of the picture on hdd
					$dateipfad=$CFG->dirroot.$datafolder."/$location";
					$mae=getimagesize($dateipfad);
					
					//Dimensions of the picture
					$breite=$mae[0];
					$hoehe=$mae[1];
					
					//create uploaded picture depending on the filetype(jpeg,gif or png)
					if (exif_imagetype($dateipfad)==IMAGETYPE_JPEG)
					{
					$picture = ImageCreateFromJPEG($dateipfad);
					}
					else if (exif_imagetype($dateipfad)==IMAGETYPE_GIF)
					{
					$picture = ImageCreateFromGIF($dateipfad);
					}
					else if (exif_imagetype($dateipfad)==IMAGETYPE_PNG)
					{
					$picture = ImageCreateFromPNG($dateipfad);
					}
				
					//create thumbnail
					$picture_tn = ImageCreateTrueColor($width_tn,$height_tn);
				
					if($breite>=$width_tn)
						$quelleX=intval($breite/2)-intval($width_tn/2);
					if($hoehe>=$height_tn)
						$quelleY=intval($hoehe/2)-intval($height_tn/2);
				
				//thumbnail scaling and quality improvement
				imagecopyresampled($picture_tn,$picture,0,0,$quelleX,$quelleY,$width_tn,$height_tn,$width_tn,$height_tn);
				
				// include thumbnail endling in filename( default="_tn")
				$filename = explode (".", $originalname);
				$db_filename=$filename[0].$thumbname.".".$filename[1];
				
				//save thumbnail and choose JPEG quality
				ImageJPEG($picture_tn,$path_thumb.$db_filename,95);
				
				//Thumbnail
				$icon=$path_web.$db_filename;
				
				//Display thumbnail + link for further information    
				$body .= templates_draw(array(
                                                  'context' => 'file',
                                                  'url' =>"{$CFG->wwwroot}mod/gallery/gallery_anzeige.php?image=$ident&width=$breite&height=$hoehe&idx=$picindex&ident=$folder->ident",
												  'icon' => $icon,
                                                 )
                                            );
                	$body.="&nbsp";
					//displayed maximum ammount of pictures per line ->new row 
					if (($i)%($files_per_row) == 0)
					{
					$body.= $linebreak; //add a new line
					}
				
				}//end run
              
			  }  //end $i < files per page
        
			}//end foreach $file
		
		//if a smaller $picindex exists create a link to it
		if($picindex>=2)
		{			
			$picindex--;
			$body.="<br><a href='{$CFG->wwwroot}mod/gallery/?ident=$folder->ident&idx=$picindex'> <<-";
			$picindex++;
		}
		//do we have any thumbnails left?
		if($number_of_rows>$files_per_page*$picindex)
		{			
			$picindex++;
			$body.="<br><a href='{$CFG->wwwroot}mod/gallery/?ident=$folder->ident&idx=$picindex'> ->>";
		}
	}//end if($files)
         
        // Deliver an apologetic message if there aren't any files or folders
        
        if (empty($files) && empty($folder->idents)) 
		{
            $body .= "<p>" . __gettext("This folder is currently empty.") . "</p>";
        }
		
		$body.="</p>";
		return $body;
}
?>